* Retraitement base fiscale 2009

set more off
clear

global year=2009

******************************************************************************************************************
* Legislative parameters converted in macro
		import excel using "$datarev/Parametres_IR.xls", first clear sheet("Parametres")  cellrange(A1:F20)
			foreach var of varlist tauxmicro_fon-tauxbnc{
				quiet sum `var' if year==$year
				global `var'=r(mean)
		}		
***************************************************************************************************************



use "$datarev/rev$year.dta",clear
foreach var of varlist _all {
	local j=upper("`var'")
	rename `var' `j'
}
gen year=$year

* Ponderation
	gen pondn=PONDV
* Caractristiques dmographiques
	* age
		gen age=year-AGED
		replace age=20 if age <20 | age==.
	* Nombre de dclarants dans la dclaration
		gen ndecl=2
		replace ndecl=1 if AGEC==9999
	* age du conjoint
		gen agec=year-AGEC if AGEC~=9999
		replace agec=20 if agec<20
	* sexe
		gen sexe=INDG
	* Structure demo des pac
			*dnpa4c : date de naissance et type de pac	
			gen npac=length(DNPA4C)/5
			quiet sum npac
			forval i=1/`r(max)' {
				local a= 2+5*(`i'-1)
				gen anaispac_`i'= year-real(substr(DNPA4C,`a' , 4 ))
				replace anaispac_`i'= year-real(substr(DNPA4C,`a' , 4 ))-2000 if substr(DNPA4C,`a' , 2 )=="00" & anaispac_`i'>=2000 & !missing(anaispac_`i') 
				replace anaispac_`i'= year-real(substr(DNPA4C,`a' , 4 ))-1900 if substr(DNPA4C,`a' , 2 )=="00" & anaispac_`i'<2000 & !missing(anaispac_`i') 
				replace anaispac_`i'= year-real(substr(DNPA4C,`a' , 4 ))-1000 if substr(DNPA4C,`a' , 2 )=="09"
			}
			
	* situation matrimoniale : O= pacs
		* Aprtir de 2006, code matrimonial passe de numrique  string. plus de retraitement  faire
		gen mat=MAT
	
	* Impot pay
		gen irtot=MNIRMM /* Impot immediat */
		gen irpv=MNIRVP /* impot pv taux propor */
		gen iravantpv=irtot-irpv
	

***********************************************************
*I)Traitements, salaires, pensions et rentes viagres  
***********************************************************
	* Certaines variables n'apparaissent pas dans dclarations IR Z1DY Z1NY Z1QV Z1AR Z1QX Z1PY
	foreach var of newlist sal_irpp chom_irpp frais_prof pension_irpp {
		gen `var'=0
		gen `var'_conj=0
		gen `var'_pac=0
	}

	* A) Salaires et chmages
	*************************
		* Distinction entre sal et chom  partir de 2002
		* A partir de 2007 : heures supplmentaires exonres
		replace sal_irpp=Z1AJ +Z1AU
		replace chom_irpp=Z1AP 

		replace sal_irpp_conj =  Z1BJ  +Z1BU
		replace chom_irpp_conj = Z1BP 
		
		* Frais pro
		replace frais_prof=Z1AK
		replace frais_prof_conj=Z1BK

	* B) Retraite
	**************
		* A partir de 1999, AS correspond uniquement aux pensions de retraites.
		* Auparavant incluait aussi pensions alimentaires reues
		* Les pensions alimentaires perues ne sont pas pris en compte
			replace pension_irpp=Z1AS
			replace pension_irpp_conj=Z1BS
			
	* C) Rentes viageres 
	**********************
		gen rente_irpp_foy=0
		local liste A B C D 
		foreach x of local liste {
			replace rente_irpp_foy= rente_irpp_foy+Z1`x'W
		}

	* D)Personne  charge PAC
	****************************
		local liste C D E F
		foreach x of local liste {
			replace sal_irpp_pac= sal_irpp_pac + Z1`x'J 
			replace chom_irpp_pac= chom_irpp_pac + Z1`x'P 
			replace frais_prof_pac=frais_prof_pac + Z1`x'K
			replace pension_irpp_pac= pension_irpp_pac+Z1`x'S
		}
		replace sal_irpp_pac=sal_irpp_pac+ Z1CU+Z1DU 


		
	* E) Au niveau foyer fiscal
	****************************
		gen sal_irpp_foy=sal_irpp+sal_irpp_conj+sal_irpp_pac
		gen chom_irpp_foy=chom_irpp+chom_irpp_conj+chom_irpp_pac
		gen frais_prof_foy=frais_prof+frais_prof_conj+frais_prof_pac
		gen pension_irpp_foy =pension_irpp+ pension_irpp_conj +pension_irpp_pac
		gen salchom_irpp_foy=sal_irpp_foy+ chom_irpp_foy
		drop Z1A* Z1B* Z1C* Z1D* Z1E* Z1F*
	
	
**************************************	
*II)  Revenus des capitaux mobiliers
**************************************	
		
		* A)Assurance-vie
		******************
			* Barme
				gen rfin_av_bar_irpp_foy = Z2CH
			* PL
				gen rfin_av_pl_irpp_foy= Z2DH
			* Total
				gen rfin_av_irpp_foy=rfin_av_bar_irpp_foy+rfin_av_pl_irpp_foy
		
		* B)Dividendes : 
		*****************
			* Au barme 
				gen rfin_div_bar_irpp_foy = Z2DC +Z2FU + Z2GR
			* Au PL  partir de 2008
				gen rfin_div_pl_irpp_foy=Z2DA
			* Total
				gen rfin_div_irpp_foy=rfin_div_pl_irpp_foy+rfin_div_bar_irpp_foy
		
			
		* C)Intrts 
		**************
			* Barme
				gen rfin_int_bar_irpp_foy= Z2TS + Z2GO+ Z2TR
			* PL report seulement  partir de 1999
				gen rfin_int_pl_irpp_foy= Z2EE
			* Total
				gen rfin_int_irpp_foy= rfin_int_bar_irpp_foy+ rfin_int_pl_irpp_foy
		
		* D) Totaux 
		**************
				gen rfin_pl_irpp_foy=rfin_av_pl_irpp_foy+rfin_div_pl_irpp_foy+rfin_int_pl_irpp_foy
				gen rfin_bar_irpp_foy=rfin_av_bar_irpp_foy+rfin_div_bar_irpp_foy+rfin_int_bar_irpp_foy
				gen rfin_irpp_foy=rfin_av_irpp_foy+rfin_div_irpp_foy+rfin_int_irpp_foy
		
			* Avant 2005, on remboursait l'IS prlev sur les dividendes via un avoir fiscal pour viter double imposition.
			* Systme a chang en 2005 en crant un abattement remplaant l'avoir fiscal
			

*******************************
*III) Revenus non salaris
*******************************
* Creation du statut jeune agriculteur et artisan pcheur en 2003.
* Creation du statut jeunes createurs  partir des revenus 2006.

* Pour ces deux catgories, les bnfices sont reports aprs dduction de l'abattement. Le montant de l'abattement utilis est ensuite report aux  cases "jeune agriculteur" et "artisan pcheur"
* Il faut donc rajouter le montant de l'abattement  aux revenus exonrs.
/* Suppression 18juin		
		gen nonsal_irpp_foy = 0
		gen nonsalexo_irpp_foy=0
		gen nonsal_foy=0
		gen defnonsal_irpp_foy=0
		gen microbic_vente=0
		gen microbic_serv=0
		gen microbnc=0
*/	
		foreach var of newlist nonsal_irpp nonsalexo_irpp nonsal defnonsal_irpp microbic_vente microbic_serv microbnc {
		gen `var'=0
		gen `var'_conj=0
		gen `var'_pac=0
		}
		
		* A) Revenus non salaris exos
		*******************************
		* Prise en comptes de l'abattement jeune agri et artisan pecheur par rapport  2002
		* Creation abattement jeunes createurs  partir des revenus 2006.
		* Changement depuis 2008 : Introduction de 5TH UH VH : revenus xonr du rgime dclaratif spcial de la section E.
/* Suppression 2008
			local liste H I J 
			foreach x of local liste {
				local liste2 N B H M P K
				foreach y of local liste2 {
					replace nonsalexo_irpp_foy=nonsalexo_irpp_foy+Z5`x'`y'
				
				}
			}
*/
			local liste H
			foreach x of local liste {
				local liste2 N B H M P 
				foreach y of local liste2 {
					replace nonsalexo_irpp=nonsalexo_irpp+Z5`x'`y'
				
				}
			}
			local liste I  
			foreach x of local liste {
				local liste2 N B H M P 
				foreach y of local liste2 {
					replace nonsalexo_irpp_conj=nonsalexo_irpp_conj+Z5`x'`y'
				
				}
			}
			local liste J 
			foreach x of local liste {
				local liste2 N B H M P 
				foreach y of local liste2 {
					replace nonsalexo_irpp_pac=nonsalexo_irpp_pac+Z5`x'`y'
				
				}
			}
	
			replace nonsalexo_irpp=nonsalexo_irpp+Z5HK + Z5IK
			replace nonsalexo_irpp_conj=nonsalexo_irpp_conj+Z5JK + Z5KK
			replace nonsalexo_irpp_pac=nonsalexo_irpp_pac+Z5LK + Z5MK
		


/*Supp 18 juin 
			local liste K L M
			foreach x of local liste {
				local liste2 N B H S K
				foreach y of local liste2 {
					replace nonsalexo_irpp_foy=nonsalexo_irpp_foy+Z5`x'`y'
				
				}
			}
*/			local liste K
			foreach x of local liste {
				local liste2 N B H S 
				foreach y of local liste2 {
					replace nonsalexo_irpp =nonsalexo_irpp +Z5`x'`y'
				
				}
			}
			local liste L
			foreach x of local liste {
				local liste2 N B H S 
				foreach y of local liste2 {
					replace nonsalexo_irpp_conj =nonsalexo_irpp_conj +Z5`x'`y'
				
				}
			}
			local liste M
			foreach x of local liste {
				local liste2 N B H S 
				foreach y of local liste2 {
					replace nonsalexo_irpp_pac =nonsalexo_irpp_pac +Z5`x'`y'
				
				}
			}

/*Supp 18 juin 			
			local liste Q R S
			foreach x of local liste {
				local liste2 L B H 
				foreach y of local liste2 {
					replace nonsalexo_irpp_foy=nonsalexo_irpp_foy+Z5`x'`y'
				
				}
			}
*/			local liste Q
			foreach x of local liste {
				local liste2 L B H 
				foreach y of local liste2 {
					replace nonsalexo_irpp=nonsalexo_irpp+Z5`x'`y'
				
				}
			}
			local liste R
			foreach x of local liste {
				local liste2 L B H 
				foreach y of local liste2 {
					replace nonsalexo_irpp_conj=nonsalexo_irpp_conj+Z5`x'`y'
				
				}
			}
			local liste S
			foreach x of local liste {
				local liste2 L B H 
				foreach y of local liste2 {
					replace nonsalexo_irpp_pac=nonsalexo_irpp_pac+Z5`x'`y'
				
				}
			}

/* Supp 18 juin
			local liste  N O P
			foreach x of local liste {
				local liste2 N B H 
				foreach y of local liste2 {
					replace nonsalexo_irpp_foy=nonsalexo_irpp_foy+Z5`x'`y'
				
				}
			}
*/
			local liste  N 
			foreach x of local liste {
				local liste2 N B H 
				foreach y of local liste2 {
					replace nonsalexo_irpp=nonsalexo_irpp+Z5`x'`y'
				
				}
			}
			local liste  O
			foreach x of local liste {
				local liste2 N B H 
				foreach y of local liste2 {
					replace nonsalexo_irpp_conj=nonsalexo_irpp_conj+Z5`x'`y'
				
				}
			}
			local liste  P
			foreach x of local liste {
				local liste2 N B H 
				foreach y of local liste2 {
					replace nonsalexo_irpp_pac=nonsalexo_irpp_pac+Z5`x'`y'
				
				}
			}
					

/* Supp 18 juin
			local liste  V W X
			foreach x of local liste {
				replace nonsalexo_irpp_foy=nonsalexo_irpp_foy+Z5S`x'
				
			}
*/		
	
/* Supp 18 juin			local liste  T U V
			foreach x of local liste {
				replace nonsalexo_irpp_foy=nonsalexo_irpp_foy+Z5`x'H
				
			}*/	
			replace nonsalexo_irpp=nonsalexo_irpp+Z5SV+Z5TH
			replace nonsalexo_irpp_conj=nonsalexo_irpp_conj+Z5SW+Z5UH
			replace nonsalexo_irpp_pac=nonsalexo_irpp_pac+Z5SX+Z5VH
		
			
		
		* B)Revenus non salaris: benefice
		**************************************
		* On rajoute 25% pour centre non agre
		* Changement par rapport  2008: introduction de HA IA JA KA LA MA : location meuble, rgime du bnfice rel, section B
		*								 introduction de NA OA PA NK OK PK : location meuble non professionnelle, rgime du bnfice rel, section C
		
/* Supp 18 juin	
			local liste H I J 
			foreach x of local liste {
				local liste2 O D C A
				foreach y of local liste2 {
					replace nonsal_irpp_foy=nonsal_irpp_foy+Z5`x'`y'
				}
				replace nonsal_irpp_foy=nonsal_irpp_foy+Z5`x'I*1.25
			}
*/			local liste H  
			foreach x of local liste {
				local liste2 O D C A
				foreach y of local liste2 {
					replace nonsal_irpp=nonsal_irpp+Z5`x'`y'
				}
				replace nonsal_irpp=nonsal_irpp+Z5`x'I*1.25
			}
			local liste I 
			foreach x of local liste {
				local liste2 O D C A
				foreach y of local liste2 {
					replace nonsal_irpp_conj=nonsal_irpp_conj+Z5`x'`y'
				}
				replace nonsal_irpp_conj=nonsal_irpp_conj+Z5`x'I*1.25
			}
			local liste J 
			foreach x of local liste {
				local liste2 O D C A
				foreach y of local liste2 {
					replace nonsal_irpp_pac=nonsal_irpp_pac+Z5`x'`y'
				}
				replace nonsal_irpp_pac=nonsal_irpp_pac+Z5`x'I*1.25
			}

			
/* Supp 18 juin			
			local liste K L M 
			foreach x of local liste {
				local liste2 C D
				foreach y of local liste2 {
					replace nonsal_irpp_foy=nonsal_irpp_foy+Z5`x'`y'
				}
				local liste2 I J A
				foreach y of local liste2 {
					replace nonsal_irpp_foy=nonsal_irpp_foy+Z5`x'`y'*1.25
				}
			}
*/		
			local liste K
			foreach x of local liste {
				local liste2 C D
				foreach y of local liste2 {
					replace nonsal_irpp=nonsal_irpp+Z5`x'`y'
				}
				local liste2 I J A
				foreach y of local liste2 {
					replace nonsal_irpp=nonsal_irpp+Z5`x'`y'*1.25
				}
			}
			local liste L 
			foreach x of local liste {
				local liste2 C D
				foreach y of local liste2 {
					replace nonsal_irpp_conj=nonsal_irpp_conj+Z5`x'`y'
				}
				local liste2 I J A
				foreach y of local liste2 {
					replace nonsal_irpp_conj=nonsal_irpp_conj+Z5`x'`y'*1.25
				}
			}
			local liste M 
			foreach x of local liste {
				local liste2 C D
				foreach y of local liste2 {
					replace nonsal_irpp_pac=nonsal_irpp_pac+Z5`x'`y'
				}
				local liste2 I J A
				foreach y of local liste2 {
					replace nonsal_irpp_pac=nonsal_irpp_pac+Z5`x'`y'*1.25
				}
			}


/* Supp 18 juin
			local liste N O P
			foreach x of local liste {
				local liste2 C D A
				foreach y of local liste2 {
					replace nonsal_irpp_foy=nonsal_irpp_foy+Z5`x'`y'
				}
				local liste2 I J K
				foreach y of local liste2 {
					replace nonsal_irpp_foy=nonsal_irpp_foy+Z5`x'`y'*1.25
				}
			}
*/
			local liste N 
			foreach x of local liste {
				local liste2 C D A
				foreach y of local liste2 {
					replace nonsal_irpp=nonsal_irpp+Z5`x'`y'
				}
				local liste2 I J K
				foreach y of local liste2 {
					replace nonsal_irpp=nonsal_irpp+Z5`x'`y'*1.25
				}
			}
			local liste O 
			foreach x of local liste {
				local liste2 C D A
				foreach y of local liste2 {
					replace nonsal_irpp_conj=nonsal_irpp_conj+Z5`x'`y'
				}
				local liste2 I J K
				foreach y of local liste2 {
					replace nonsal_irpp_conj=nonsal_irpp_conj+Z5`x'`y'*1.25
				}
			}
			local liste P
			foreach x of local liste {
				local liste2 C D A
				foreach y of local liste2 {
					replace nonsal_irpp_pac=nonsal_irpp_pac+Z5`x'`y'
				}
				local liste2 I J K
				foreach y of local liste2 {
					replace nonsal_irpp_pac=nonsal_irpp_pac+Z5`x'`y'*1.25
				}
			}
	
/* Supp 18 juin
			local liste Q R S
			foreach x of local liste {
				local liste2 C
				foreach y of local liste2 {
					replace nonsal_irpp_foy=nonsal_irpp_foy+Z5`x'`y'
				}
				local liste2 I
				foreach y of local liste2 {
					replace nonsal_irpp_foy=nonsal_irpp_foy+Z5`x'`y'*1.25
				}
			}
*/
			local liste Q
			foreach x of local liste {
				local liste2 C
				foreach y of local liste2 {
					replace nonsal_irpp=nonsal_irpp+Z5`x'`y'
				}
				local liste2 I
				foreach y of local liste2 {
					replace nonsal_irpp=nonsal_irpp+Z5`x'`y'*1.25
				}
			}
			local liste R
			foreach x of local liste {
				local liste2 C
				foreach y of local liste2 {
					replace nonsal_irpp_conj=nonsal_irpp_conj+Z5`x'`y'
				}
				local liste2 I
				foreach y of local liste2 {
					replace nonsal_irpp_conj=nonsal_irpp_conj+Z5`x'`y'*1.25
				}
			}
			local liste S
			foreach x of local liste {
				local liste2 C
				foreach y of local liste2 {
					replace nonsal_irpp_pac=nonsal_irpp_pac+Z5`x'`y'
				}
				local liste2 I
				foreach y of local liste2 {
					replace nonsal_irpp_pac=nonsal_irpp_pac+Z5`x'`y'*1.25
				}
			}
			
						
			replace nonsal_irpp=nonsal_irpp+Z5SN*1.25
			replace nonsal_irpp_conj=nonsal_irpp_conj+Z5NS*1.25
			replace nonsal_irpp_pac=nonsal_irpp_pac+Z5OS*1.25
			replace nonsal_irpp=nonsal_irpp +Z5JG
			replace nonsal_irpp_conj=nonsal_irpp_conj+Z5RF
			replace nonsal_irpp_pac=nonsal_irpp_pac+Z5SF


		
		* C) Revenus non salairs: plus-values voir section plus-value rfin_pv_pro_irpp_foy
		***************************************************************************************	

		* D)Revenus non salaris: dficits
		***********************************	
			* Ajout dficit declaration controle (conjoint+PAC) avant c'tait seulement total  partir rev 2005
			* Introduction distinction avec ou sans AA pour regime declaration controle  partir des revenus 2007
	
		*Changement par rapport  2008 : Introduction de QA QJ RA RJ SK SJ : Dficit location meuble en bnfice rel, section B
		*								 Introduction de NY NZ OY OZ PY PZ : Dficit location meuble non professionnel en bnfice rel, section C
/* Supp 18 juin
			local liste H I J  
			foreach x of local liste {
				local liste2 F L
				foreach y of local liste2 {
					replace defnonsal_irpp_foy=defnonsal_irpp_foy+Z5`x'`y'
				}
			}
*/
			local liste H 
			foreach x of local liste {
				local liste2 F L
				foreach y of local liste2 {
					replace defnonsal_irpp=defnonsal_irpp+Z5`x'`y'
				}
			}
			local liste I 
			foreach x of local liste {
				local liste2 F L
				foreach y of local liste2 {
					replace defnonsal_irpp_conj=defnonsal_irpp_conj+Z5`x'`y'
				}
			}
			local liste  J
			foreach x of local liste {
				local liste2 F L
				foreach y of local liste2 {
					replace defnonsal_irpp_pac=defnonsal_irpp_pac+Z5`x'`y'
				}
			}

/* Supp 18 juin 

			local liste K L M 
			foreach x of local liste {
				local liste2 F L G M
				foreach y of local liste2 {
					replace defnonsal_irpp_foy=defnonsal_irpp_foy+Z5`x'`y'
				}
			}
			local liste N O P
			foreach x of local liste {
				local liste2 F L G M
				foreach y of local liste2 {
					replace defnonsal_irpp_foy=defnonsal_irpp_foy+Z5`x'`y'
				}
			}
*/
			local liste K  N 
			foreach x of local liste {
				local liste2 F G L M
				foreach y of local liste2 {
					replace defnonsal_irpp=defnonsal_irpp+Z5`x'`y'
				}
			}
			local liste  L  O 
			foreach x of local liste {
				local liste2 F G L M
				foreach y of local liste2 {
					replace defnonsal_irpp_conj=defnonsal_irpp_conj+Z5`x'`y'
				}
			}
			local liste  M  P
			foreach x of local liste {
				local liste2 F G L M
				foreach y of local liste2 {
					replace defnonsal_irpp_pac=defnonsal_irpp_pac+Z5`x'`y'
				}
			}
			
/* Supp 18 juin 	
			local liste N O P
			foreach x of local liste {
				local liste2 Y Z
				foreach y of local liste2 {
					replace defnonsal_irpp_foy=defnonsal_irpp_foy+Z5`x'`y'
				}
			}
*/
			local liste N
			foreach x of local liste {
				local liste2 Y Z
				foreach y of local liste2 {
					replace defnonsal_irpp=defnonsal_irpp+Z5`x'`y'
				}
			}
			local liste O
			foreach x of local liste {
				local liste2 Y Z
				foreach y of local liste2 {
					replace defnonsal_irpp_conj=defnonsal_irpp_conj+Z5`x'`y'
				}
			}
			local liste P
			foreach x of local liste {
				local liste2 Y Z
				foreach y of local liste2 {
					replace defnonsal_irpp_pac=defnonsal_irpp_pac+Z5`x'`y'
				}
			}

/* Supp 18 juin
			local liste Q R S
			foreach x of local liste {
				local liste2 A J E K
				foreach y of local liste2 {
					replace defnonsal_irpp_foy=defnonsal_irpp_foy+Z5`x'`y'
				}
			}*/
			local liste Q 
			foreach x of local liste {
				local liste2 A J E K
				foreach y of local liste2 {
					replace defnonsal_irpp=defnonsal_irpp+Z5`x'`y'
				}
			}
			local liste  R  
			foreach x of local liste {
				local liste2 A J E K
				foreach y of local liste2 {
					replace defnonsal_irpp_conj=defnonsal_irpp_conj+Z5`x'`y'
				}
			}
			local liste S 
			foreach x of local liste {
				local liste2 A J E K
				foreach y of local liste2 {
					replace defnonsal_irpp_pac=defnonsal_irpp_pac+Z5`x'`y'
				}
			}
/* Supp 18 juin	
			replace defnonsal_irpp_foy=defnonsal_irpp_foy+Z5SP+Z5NU+Z5OU+Z5JJ+Z5RG+Z5SG
*/
			replace defnonsal_irpp=defnonsal_irpp+Z5SP + Z5JJ
			replace defnonsal_irpp_conj=defnonsal_irpp_conj+Z5NU + Z5RG
			replace defnonsal_irpp_pac=defnonsal_irpp_pac+Z5OU + Z5SG

			
		* E)Revenus non salaris: micro-fonciers et auto-entrepreneurs
		*************************************************************
		* Recalcul du bnfice pour les auto-entrepreneurs et le rgime micro-entreprise (il faut dduire un abattement du chiffre d'affaire dclar pour retrouver le bnfice rel)
		* Changement par rapport  2009 : Introduction de 5(T,U,V)*(A,C,B,D,E,G) : Autoentrepreneurs
			* Micro bic et autoentrepeneur : vente de marchandises
/* Supp 18 juin				
				local liste K L M N O P
				foreach x of local liste {
					local liste2 O
					foreach y of local liste2 {
						replace microbic_vente=microbic_vente+Z5`x'`y' * (1-$tauxbic_vente)
					}
				}
*/
				local liste K  N 
				foreach x of local liste {
					local liste2 O 
					foreach y of local liste2 {
						replace microbic_vente=microbic_vente+Z5`x'`y' * (1-$tauxbic_vente)
					}
				}
				local liste  L  O 
				foreach x of local liste {
					local liste2 O 
					foreach y of local liste2 {
						replace microbic_vente_conj=microbic_vente_conj+Z5`x'`y' * (1-$tauxbic_vente)
					}
				}
				local liste M  P
				foreach x of local liste {
					local liste2 O 
					foreach y of local liste2 {
						replace microbic_vente_pac=microbic_vente_pac+Z5`x'`y' * (1-$tauxbic_vente)
					}
				}	
				
/* Supp 18 juin					
				local liste T U V
				foreach x of local liste {
					local liste2 A C
					foreach y of local liste2 {
						replace microbic_vente=microbic_vente+Z5`x'`y' * (1-$tauxbic_vente)
					}
				}
*/				local liste T
				foreach x of local liste {
					local liste2 A C
					foreach y of local liste2 {
						replace microbic_vente=microbic_vente+Z5`x'`y' * (1-$tauxbic_vente)
					}
				}
				local liste U 
				foreach x of local liste {
					local liste2 A C
					foreach y of local liste2 {
						replace microbic_vente_conj=microbic_vente_conj+Z5`x'`y' * (1-$tauxbic_vente)
					}
				}
				local liste V
				foreach x of local liste {
					local liste2 A C
					foreach y of local liste2 {
						replace microbic_vente_pac=microbic_vente_pac+Z5`x'`y' * (1-$tauxbic_vente)
					}
				}


				
			* Micro bic et autoentrepeneur : prestations de services
/*Supp 18 juin 	
				local liste K L M N O P
				foreach x of local liste {
					local liste2 P
					foreach y of local liste2 {
						replace microbic_serv=microbic_serv+Z5`x'`y' * (1-$tauxbic_serv)
					}
				}*/
				
				local liste K  N 
				foreach x of local liste {
					local liste2 P
					foreach y of local liste2 {
						replace microbic_serv=microbic_serv+Z5`x'`y' * (1-$tauxbic_serv)
					}
				}
				local liste  L  O 
				foreach x of local liste {
					local liste2 P
					foreach y of local liste2 {
						replace microbic_serv_conj=microbic_serv_conj+Z5`x'`y' * (1-$tauxbic_serv)
					}
				}
				local liste  M  P
				foreach x of local liste {
					local liste2 P
					foreach y of local liste2 {
						replace microbic_serv_pac=microbic_serv_pac+Z5`x'`y' * (1-$tauxbic_serv)
					}
				}
				
/*Supp 18 juin 					
				local liste T U V
				foreach x of local liste {
					local liste2 B D
					foreach y of local liste2 {
						replace microbic_serv=microbic_serv+Z5`x'`y' * (1-$tauxbic_serv)
					}
				}
*/				
				local liste T 
				foreach x of local liste {
					local liste2 B D
					foreach y of local liste2 {
						replace microbic_serv=microbic_serv+Z5`x'`y' * (1-$tauxbic_serv)
					}
				}				
				local liste U 
				foreach x of local liste {
					local liste2 B D
					foreach y of local liste2 {
						replace microbic_serv_conj=microbic_serv_conj+Z5`x'`y' * (1-$tauxbic_serv)
					}
				}				
				local liste V
				foreach x of local liste {
					local liste2 B D
					foreach y of local liste2 {
						replace microbic_serv_pac=microbic_serv_pac+Z5`x'`y' * (1-$tauxbic_serv)
					}
				}


				
			* Micro bnc et autoentrepeneur bnc
/*Supp 18 juin 	local liste H I J
				foreach x of local liste {
					local liste2 Q
					foreach y of local liste2 {
						replace microbnc=microbnc+Z5`x'`y' * (1-$tauxbnc)
					}
				}
*/
				local liste H 
				foreach x of local liste {
					local liste2 Q
					foreach y of local liste2 {
						replace microbnc=microbnc+Z5`x'`y' * (1-$tauxbnc)
					}
				}
				local liste  I  
				foreach x of local liste {
					local liste2 Q
					foreach y of local liste2 {
						replace microbnc_conj=microbnc_conj+Z5`x'`y' * (1-$tauxbnc)
					}
				}
				local liste  J 
				foreach x of local liste {
					local liste2 Q
					foreach y of local liste2 {
						replace microbnc_pac=microbnc_pac+Z5`x'`y' * (1-$tauxbnc)
					}
				}
				
/* Supp 18 juin				
				local liste K L M
				foreach x of local liste {
					local liste2 U
					foreach y of local liste2 {
						replace microbnc=microbnc+Z5`x'`y' * (1-$tauxbnc)
					}
				}
*/				replace microbnc=microbnc+Z5KU * (1-$tauxbnc)
				replace microbnc_conj=microbnc_conj+Z5LU * (1-$tauxbnc)
				replace microbnc_pac=microbnc_pac+Z5MU * (1-$tauxbnc)

				
/* Supp 18 juin		
				local liste T U V
				foreach x of local liste {
					local liste2 E G
					foreach y of local liste2 {
						replace microbnc=microbnc+Z5`x'`y' * (1-$tauxbnc)
					}
				}
				*/
				
				local liste T
				foreach x of local liste {
					local liste2 E G
					foreach y of local liste2 {
						replace microbnc=microbnc+Z5`x'`y' * (1-$tauxbnc)
					}
				}
				local liste U 
				foreach x of local liste {
					local liste2 E G
					foreach y of local liste2 {
						replace microbnc_conj=microbnc_conj+Z5`x'`y' * (1-$tauxbnc)
					}
				}
				local liste V
				foreach x of local liste {
					local liste2 E G
					foreach y of local liste2 {
						replace microbnc_pac=microbnc_pac+Z5`x'`y' * (1-$tauxbnc)
					}
				}
/* Supp 18 juin				
			replace nonsal_irpp_foy=nonsal_irpp_foy+microbnc+ microbic_serv+microbic_vente
			replace nonsal_foy=nonsal_irpp_foy+nonsalexo_irpp_foy
*/
			foreach var of varlist nonsal_irpp {
				replace `var'=`var'+microbnc+ microbic_serv+microbic_vente
				replace `var'_conj=`var'_conj+microbnc_conj+ microbic_serv_conj+microbic_vente_conj
				replace `var'_pac=`var'_pac+microbnc_pac+ microbic_serv_pac+microbic_vente_pac
			}
			foreach var of varlist nonsal {
				replace `var'=`var'_irpp+`var'exo_irpp
				replace `var'_conj=`var'_irpp_conj+`var'exo_irpp_conj
				replace `var'_pac=`var'_irpp_pac+`var'exo_irpp_pac
			}

							
			gen nonsal_irpp_foy=nonsal_irpp+nonsal_irpp_conj+nonsal_irpp_pac
			gen nonsalexo_irpp_foy=nonsalexo_irpp+nonsalexo_irpp_conj+nonsalexo_irpp_pac
			gen nonsal_foy=nonsal_irpp_foy+nonsalexo_irpp_foy
	

			
************************			
*IV)  Revenus fonciers
************************

		* A)Regime normal net de charges et intrts
		********************************************
			*en cas de benefices
				gen rfon_normal_irpp_foy=Z4BA
			* en cas de deficits: deficts catgoriels ou global
				gen rfon_defcat_foy= Z4BB
				gen rfon_defglo_foy=Z4BC
				
		* B) Regime micro-foncier brut
		******************************
			* BE reporte seulement les recettes brutes du micro-foncier. On dduit le taux d'abattement pour avoir le bnfice
			gen rfon_micro_irpp_foy= Z4BE *${tauxmicro_fon}
			gen rfon_irpp_foy=rfon_normal_irpp_foy+rfon_micro_irpp_foy

******************
* V) Plus value	 *	
******************
		
		gen rfin_pv_pro_irpp_foy=0
		gen rfin_mv_pro_irpp_foy=0
		gen rfin_pv_fon_irpp_foy=0
		gen rfin_pv_fin_irpp_foy=0
		gen rfin_mv_fin_irpp_foy=0
		gen rfin_pv_options_foy=0
							
		*A) Plus-values professionnelles
		********************************
		
			* Plus values
				* Ajout PV declaration controle (conjoint+PAC) avant c'tait seulement total  partir rev 2005
				* Suppression distinction avec ou sans CGA pour PV  partir revenus 2007
			
					local liste H I J
							foreach x of local liste {
								local liste2 W X E V R
								foreach y of local liste2 {
									replace rfin_pv_pro_irpp_foy=rfin_pv_pro_irpp_foy+Z5`x'`y'
								
								}
							}
					
					local liste N O P
					foreach x of local liste {
						local liste2 X Q E
						foreach y of local liste2 {
							replace rfin_pv_pro_irpp_foy=rfin_pv_pro_irpp_foy+Z5`x'`y'
						
						}
					}
					local liste  K L M
					foreach x of local liste {
						local liste2 X Q E Y V 
						foreach y of local liste2 {
							replace rfin_pv_pro_irpp_foy=rfin_pv_pro_irpp_foy+Z5`x'`y'
						
						}
					}
					
					local liste  Q R S
					foreach x of local liste {
						local liste2 D
						foreach y of local liste2 {
							replace rfin_pv_pro_irpp_foy=rfin_pv_pro_irpp_foy+Z5`x'`y'
						
						}
					}
					replace rfin_pv_pro_irpp_foy=rfin_pv_pro_irpp_foy+Z5SO
					replace rfin_pv_pro_irpp_foy=rfin_pv_pro_irpp_foy+Z5NT
					replace rfin_pv_pro_irpp_foy=rfin_pv_pro_irpp_foy+Z5OT

			* Moins-value
				* Pas de changement depuis 2005					
						local liste  K L M
						foreach x of local liste {
							local liste2 R W
							foreach y of local liste2 {
								replace rfin_mv_pro_irpp_foy=rfin_mv_pro_irpp_foy+Z5`x'`y'
							
							}
						}
						
						local liste   H I J
						foreach x of local liste {
							local liste2 S U
							foreach y of local liste2 {
								replace rfin_mv_pro_irpp_foy=rfin_mv_pro_irpp_foy+Z5`x'`y'
							
							}
						}

						local liste   N O P
						foreach x of local liste {
							local liste2  R 
							foreach y of local liste2 {
								replace rfin_mv_pro_irpp_foy=rfin_mv_pro_irpp_foy+Z5`x'`y'
							
							}
						}
						replace rfin_mv_pro_irpp_foy=rfin_mv_pro_irpp_foy+Z5KZ

			
		* B) Plus-values foncires	(n'existe plus)
		***************************
	
		*C) Plus-values financires (on laisse de cote pv retraite dirigeant)
		***************************
		* Apparition de VP Pv de cession de titres de jeunes entreprises innovantes
			* Apparition de VS qui est inclus dans VI
			* Regime normal + pv de PEA clotur avant 2 ans + pv capital risque 
				* Avant 2010: seuls les pv suprieurs  25000 euros sont dclares. QUand pv = 24000 rien. Quand pv > 26000 => 26000 
				* Bunching potentiel !
				local liste   V
						foreach x of local liste {
							local liste2  G E L M C P 
							foreach y of local liste2 {
								replace rfin_pv_fin_irpp_foy=rfin_pv_fin_irpp_foy+Z3`x'`y'						
							}
						}
				replace rfin_mv_fin_irpp_foy=rfin_mv_fin_irpp_foy+Z3VH

			* Stock options :
				*Introduction VD en 2007: option taxe  18%
		
					local liste   T U
						foreach x of local liste {
							local liste2  V W X
							foreach y of local liste2 {
								replace rfin_pv_options_foy=rfin_pv_options_foy+Z1`x'`y'
							
							}
						}
					local liste   V
						foreach x of local liste {
							local liste2 J K I F D
							foreach y of local liste2 {
								replace rfin_pv_options_foy=rfin_pv_options_foy+Z3`x'`y'
							
							}
						}

	
			gen rfin_pv_irpp_foy=rfin_pv_fin_irpp_foy+rfin_pv_fon_irpp_foy+rfin_pv_pro_irpp_foy+rfin_pv_options_foy
			gen rfin_mv_irpp_foy=rfin_mv_fin_irpp_foy+rfin_mv_pro_irpp_foy

***********************************************************************
		
			keep year pondn-rfin_mv_irpp_foy
		drop micro* 
		gen idfoy=_n
		#delimit;
			order year idfoy pondn ndecl  age agec sexe mat npac  anaispac* 
			salchom* sal* chom* pens* rente* nonsal* nonsal_irpp* defnonsal_irpp* nonsalexo_irpp* rfon* 
			rfin_irpp_foy rfin_bar_irpp_foy rfin_pl_irpp_foy rfin_int_irpp_foy rfin_int_bar_irpp_foy rfin_int_pl_irpp_foy rfin_div_irpp_foy rfin_div_bar_irpp_foy rfin_div_pl_irpp_foy rfin_av_irpp_foy rfin_av_bar_irpp_foy rfin_av_pl_irpp_foy 
			rfin_pv_irpp_foy rfin_pv_pro_irpp_foy rfin_pv_fon_irpp_foy rfin_pv_fin_irpp_foy rfin_pv_options_foy rfin_mv_irpp_foy rfin_mv_pro_irpp_foy  rfin_mv_fin_irpp_foy ;
			 #delimit cr
		save "$wfrev/rev${year}.dta",replace
		
